<?php

namespace App\Http\Controllers;

use App\Models\Redeem;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedeemController extends Controller
{
    public function index()
    {
        return view('redeem.index');
    }

    public function create()
    {
        $redeems = Redeem::latest()->get();
        return view('redeem.create', compact('redeems'));
    }

    public function submit(Request $request)
    {
        $request->validate([
            'code' => 'required|exists:redeems,code'
        ], [
            'code.exists' => 'Invalid Redeem Code'
        ]);
        $redeem = Redeem::firstWhere('code', $request->code);
        $reseller = Reseller::firstWhere('user_id', Auth::id());
        $reseller->balance += $redeem->amount;
        $reseller->save();

        $redeem->delete();
        flash()->addSuccess($redeem->amount . '$' . ' Redeemed Sucessfully');
        return back();
    }

    public function store(Request $request)
    {
        if (Auth::user()->role == 'admin') {
            $userId = Auth::id();
            $redeem = new Redeem();
            $redeem->code = $request->code;
            $redeem->amount = $request->amount;
            $redeem->user_id = $userId;
            $redeem->save();
            flash()->addSuccess($request->amount . '$' . ' Redeem Code Generated');
            return back();
        } else {
            $userId = Auth::id();
            $reseller = Reseller::firstWhere('user_id', Auth::id());
            $amount = $request->amount;
            if (($amount * 0.8) <= $reseller->balance) {
                if ($amount >= '5') {
                    $reseller->balance -= $amount * 0.8;
                    $reseller->save();
                } else {
                    $reseller->balance -= $amount;
                    $reseller->save();
                }
                $redeem = new Redeem();
                $redeem->code = $request->code;
                $redeem->amount = $request->amount;
                $redeem->user_id = $userId;
                $redeem->save();
                flash()->addSuccess($request->amount . '$' . ' Redeem Code Generated');
                return back();
            } else {
                flash()->addError('Balance is less than ' . ($amount * 0.8) . '$');
                return back();
            }
        }
    }
}
